<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->string('description', 255)->nullable();
			$table->integer('post_type_id')->unsigned();
			$table->integer('created_by')->unsigned();
			$table->integer('edited_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}