<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ServiceProvider extends Eloquent {

	protected $table = 'service_provider';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'provider_location', 'description_en', 'description_ar', 'email', 'mobile', 'phone', 'hotline', 'additional_info_en', 'additional_info_ar', 'responsible_person', 'service_category_id');

	public function service()
	{
		return $this->belongsTo('ServiceCategory', 'service_category_id');
	}

}