<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HouseStaff extends Eloquent {

	protected $table = 'house_staff';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('house_id', 'type', 'name_en', 'name_ar', 'phone', 'email', 'join_date', 'biography_en', 'biography_ar', 'details_en', 'details_ar', 'status', 'departure_date');

	public function house()
	{
		return $this->belongsTo('House', 'house_id');
	}

}