<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HouseProgramActivity extends Eloquent {

	protected $table = 'house_program_activity';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('house_id', 'name_en', 'name_ar', 'details_en', 'details_ar');

	public function house()
	{
		return $this->belongsTo('House', 'house_id');
	}

}