<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class HouseGallery extends Eloquent {

	protected $table = 'house_gallery';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title_en', 'title_ar', 'house_id');

	public function house()
	{
		return $this->belongsTo('House', 'house_id');
	}

}