<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Donation extends Eloquent {

	protected $table = 'donation';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('amount', 'donation_date', 'is_specific', 'payment_method', 'payment_reference', 'donation_type', 'user_id', 'orphan_id', 'house_id', 'special_need_id', 'donation_category_id');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function donation()
	{
		return $this->belongsTo('DonationCategory', 'donation_category_id');
	}

	public function orphan()
	{
		return $this->belongsTo('Orphan', 'orphan_id');
	}

	public function house()
	{
		return $this->belongsTo('House', 'house_id');
	}

	public function need()
	{
		return $this->belongsTo('HouseSpecialNeed', 'special_need_id');
	}

}