<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStoresTable extends Migration {

	public function up()
	{
		Schema::create('stores', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id');
			$table->enum('gender', array('male', 'female', 'both'));
			$table->integer('rate')->default('1');
			$table->tinyInteger('pay_commission');
			$table->string('money_password', 400);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('stores');
	}
}