<?php

namespace App\Models;

class WallMessages extends Eloquent {

	protected $table = 'wall_messages';
	public $timestamps = true;

	public function likes()
	{
		return $this->hasMany('App\Models\Like_');
	}

	public function course()
	{
		return $this->belongsTo('App\Models\Course');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function replies()
	{
		return $this->hasMany('App\Models\WallMessages')->orderBy('created_at', 'ASC');
	}

	public function reachedAchievement()
	{
		return $this->belongsTo('App\Models\ReachedAchievements');
	}

}