<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('problems', function(Blueprint $table) {
			$table->foreign('problem_type_id')->references('id')->on('problem_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('problems', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('resources', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('topic_replies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('topic_replies', function(Blueprint $table) {
			$table->foreign('resported_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('likes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('likes', function(Blueprint $table) {
			$table->foreign('wall_message_id')->references('id')->on('wall_messages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('module_problem_user_attempted', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('module_problem_user_attempted', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('module_problem_user_attempted', function(Blueprint $table) {
			$table->foreign('problem_id')->references('id')->on('problems')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('problems_code', function(Blueprint $table) {
			$table->foreign('problem_id')->references('id')->on('problems')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('problems_completion', function(Blueprint $table) {
			$table->foreign('problem_id')->references('id')->on('problems')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('problems_selection', function(Blueprint $table) {
			$table->foreign('problem_id')->references('id')->on('problems')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('survey_answers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('survey_answers', function(Blueprint $table) {
			$table->foreign('survey_question_id')->references('id')->on('survey_questions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->foreign('user_from')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->foreign('user_to')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->foreign('problem_id')->references('id')->on('problems')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->foreign('defiant_user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->foreign('opponent_user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->foreign('winner_user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->foreign('user_a_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->foreign('user_b_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('historical_levels', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('historical_levels', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('historical_levels', function(Blueprint $table) {
			$table->foreign('level_id')->references('id')->on('levels')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('survey_questions', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->foreign('wall_message_id')->references('id')->on('wall_messages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->foreign('reached_achievement_id')->references('id')->on('reached_achievements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->foreign('reported_user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('module_problem_user_summary', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('module_problem_user_summary', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('module_problem_user_summary', function(Blueprint $table) {
			$table->foreign('problem_id')->references('id')->on('problems')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('groups')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('level_id')->references('id')->on('levels')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reached_achievements', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reached_achievements', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reached_achievements', function(Blueprint $table) {
			$table->foreign('achievement_id')->references('id')->on('achievements')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('global_notifications', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('global_notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('module_resource_user_summary', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('module_resource_user_summary', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('module_resource_user_summary', function(Blueprint $table) {
			$table->foreign('resource_id')->references('id')->on('resources')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('module_problem', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('module_problem', function(Blueprint $table) {
			$table->foreign('problem_id')->references('id')->on('problems')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('module_problem', function(Blueprint $table) {
			$table->foreign('best_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('module_resource', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('module_resource', function(Blueprint $table) {
			$table->foreign('resource_id')->references('id')->on('resources')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('module_user', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('module_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('module_resource_user_views', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('module_resource_user_views', function(Blueprint $table) {
			$table->foreign('resource_id')->references('id')->on('resources')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('module_resource_user_views', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('reached_achievement_id')->references('id')->on('reached_achievements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('supporters', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_subject_id_foreign');
		});
		Schema::table('problems', function(Blueprint $table) {
			$table->dropForeign('problems_problem_type_id_foreign');
		});
		Schema::table('problems', function(Blueprint $table) {
			$table->dropForeign('problems_subject_id_foreign');
		});
		Schema::table('resources', function(Blueprint $table) {
			$table->dropForeign('resources_subject_id_foreign');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->dropForeign('modules_course_id_foreign');
		});
		Schema::table('topic_replies', function(Blueprint $table) {
			$table->dropForeign('topic_replies_user_id_foreign');
		});
		Schema::table('topic_replies', function(Blueprint $table) {
			$table->dropForeign('topic_replies_resported_user_id_foreign');
		});
		Schema::table('groups', function(Blueprint $table) {
			$table->dropForeign('groups_course_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_user_id_foreign');
		});
		Schema::table('purchases', function(Blueprint $table) {
			$table->dropForeign('purchases_course_id_foreign');
		});
		Schema::table('likes', function(Blueprint $table) {
			$table->dropForeign('likes_user_id_foreign');
		});
		Schema::table('likes', function(Blueprint $table) {
			$table->dropForeign('likes_wall_message_id_foreign');
		});
		Schema::table('module_problem_user_attempted', function(Blueprint $table) {
			$table->dropForeign('module_problem_user_attempted_module_id_foreign');
		});
		Schema::table('module_problem_user_attempted', function(Blueprint $table) {
			$table->dropForeign('module_problem_user_attempted_user_id_foreign');
		});
		Schema::table('module_problem_user_attempted', function(Blueprint $table) {
			$table->dropForeign('module_problem_user_attempted_problem_id_foreign');
		});
		Schema::table('problems_code', function(Blueprint $table) {
			$table->dropForeign('problems_code_problem_id_foreign');
		});
		Schema::table('problems_completion', function(Blueprint $table) {
			$table->dropForeign('problems_completion_problem_id_foreign');
		});
		Schema::table('problems_selection', function(Blueprint $table) {
			$table->dropForeign('problems_selection_problem_id_foreign');
		});
		Schema::table('survey_answers', function(Blueprint $table) {
			$table->dropForeign('survey_answers_user_id_foreign');
		});
		Schema::table('survey_answers', function(Blueprint $table) {
			$table->dropForeign('survey_answers_survey_question_id_foreign');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->dropForeign('chats_user_from_foreign');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->dropForeign('chats_user_to_foreign');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->dropForeign('connections_user_id_foreign');
		});
		Schema::table('connections', function(Blueprint $table) {
			$table->dropForeign('connections_course_id_foreign');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->dropForeign('duels_course_id_foreign');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->dropForeign('duels_problem_id_foreign');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->dropForeign('duels_defiant_user_id_foreign');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->dropForeign('duels_opponent_user_id_foreign');
		});
		Schema::table('duels', function(Blueprint $table) {
			$table->dropForeign('duels_winner_user_id_foreign');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->dropForeign('friendships_user_a_id_foreign');
		});
		Schema::table('friendships', function(Blueprint $table) {
			$table->dropForeign('friendships_user_b_id_foreign');
		});
		Schema::table('historical_levels', function(Blueprint $table) {
			$table->dropForeign('historical_levels_course_id_foreign');
		});
		Schema::table('historical_levels', function(Blueprint $table) {
			$table->dropForeign('historical_levels_user_id_foreign');
		});
		Schema::table('historical_levels', function(Blueprint $table) {
			$table->dropForeign('historical_levels_level_id_foreign');
		});
		Schema::table('survey_questions', function(Blueprint $table) {
			$table->dropForeign('survey_questions_course_id_foreign');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->dropForeign('wall_messages_course_id_foreign');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->dropForeign('wall_messages_user_id_foreign');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->dropForeign('wall_messages_wall_message_id_foreign');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->dropForeign('wall_messages_reached_achievement_id_foreign');
		});
		Schema::table('wall_messages', function(Blueprint $table) {
			$table->dropForeign('wall_messages_reported_user_id_foreign');
		});
		Schema::table('module_problem_user_summary', function(Blueprint $table) {
			$table->dropForeign('module_problem_user_summary_module_id_foreign');
		});
		Schema::table('module_problem_user_summary', function(Blueprint $table) {
			$table->dropForeign('module_problem_user_summary_user_id_foreign');
		});
		Schema::table('module_problem_user_summary', function(Blueprint $table) {
			$table->dropForeign('module_problem_user_summary_problem_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_group_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_level_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_user_id_foreign');
		});
		Schema::table('reached_achievements', function(Blueprint $table) {
			$table->dropForeign('reached_achievements_user_id_foreign');
		});
		Schema::table('reached_achievements', function(Blueprint $table) {
			$table->dropForeign('reached_achievements_course_id_foreign');
		});
		Schema::table('reached_achievements', function(Blueprint $table) {
			$table->dropForeign('reached_achievements_achievement_id_foreign');
		});
		Schema::table('global_notifications', function(Blueprint $table) {
			$table->dropForeign('global_notifications_course_id_foreign');
		});
		Schema::table('global_notifications', function(Blueprint $table) {
			$table->dropForeign('global_notifications_user_id_foreign');
		});
		Schema::table('module_resource_user_summary', function(Blueprint $table) {
			$table->dropForeign('module_resource_user_summary_user_id_foreign');
		});
		Schema::table('module_resource_user_summary', function(Blueprint $table) {
			$table->dropForeign('module_resource_user_summary_module_id_foreign');
		});
		Schema::table('module_resource_user_summary', function(Blueprint $table) {
			$table->dropForeign('module_resource_user_summary_resource_id_foreign');
		});
		Schema::table('module_problem', function(Blueprint $table) {
			$table->dropForeign('module_problem_module_id_foreign');
		});
		Schema::table('module_problem', function(Blueprint $table) {
			$table->dropForeign('module_problem_problem_id_foreign');
		});
		Schema::table('module_problem', function(Blueprint $table) {
			$table->dropForeign('module_problem_best_user_id_foreign');
		});
		Schema::table('module_resource', function(Blueprint $table) {
			$table->dropForeign('module_resource_module_id_foreign');
		});
		Schema::table('module_resource', function(Blueprint $table) {
			$table->dropForeign('module_resource_resource_id_foreign');
		});
		Schema::table('module_user', function(Blueprint $table) {
			$table->dropForeign('module_user_module_id_foreign');
		});
		Schema::table('module_user', function(Blueprint $table) {
			$table->dropForeign('module_user_user_id_foreign');
		});
		Schema::table('module_resource_user_views', function(Blueprint $table) {
			$table->dropForeign('module_resource_user_views_module_id_foreign');
		});
		Schema::table('module_resource_user_views', function(Blueprint $table) {
			$table->dropForeign('module_resource_user_views_resource_id_foreign');
		});
		Schema::table('module_resource_user_views', function(Blueprint $table) {
			$table->dropForeign('module_resource_user_views_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_reached_achievement_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_user_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_course_id_foreign');
		});
		Schema::table('supporters', function(Blueprint $table) {
			$table->dropForeign('supporters_course_id_foreign');
		});
	}
}