<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModuleResourceUserSummaryTable extends Migration {

	public function up()
	{
		Schema::create('module_resource_user_summary', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('module_id')->unsigned();
			$table->decimal('rating', 8,2);
			$table->text('comment');
			$table->tinyInteger('anonymous');
			$table->timestamp('rated_at');
			$table->integer('resource_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('module_resource_user_summary');
	}
}