<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModuleProblemUserSummaryTable extends Migration {

	public function up()
	{
		Schema::create('module_problem_user_summary', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('module_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('problem_id')->unsigned();
			$table->decimal('best_score', 8,2)->default('0');
			$table->boolean('solved');
			$table->integer('n_problems_attempts')->default('0');
			$table->boolean('skipped');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('module_problem_user_summary');
	}
}