<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('dni', 255);
			$table->string('first_name', 50);
			$table->date('birth_date')->nullable();
			$table->string('last_name', 50);
			$table->tinyInteger('gender');
			$table->string('email', 255);
			$table->string('avatar', 15);
			$table->string('password', 60);
			$table->string('facebook_id', 60)->nullable();
			$table->string('google_id', 60);
			$table->tinyInteger('confirmed')->default('0');
			$table->string('confirmation_code', 255)->nullable();
			$table->string('remember_token', 100)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}