<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFactoryRouteTable extends Migration {

	public function up()
	{
		Schema::create('factory_route', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('factory_id')->unsigned();
			$table->string('name');
			$table->text('description')->nullable();
			$table->timestamps();
			$table->datetime('softDeletes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('factory_route');
	}
}