<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTourPackageTable extends Migration {

	public function up()
	{
		Schema::create('tour_package', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->text('description')->nullable();
			$table->smallInteger('minimum_participant');
			$table->smallInteger('maximum_participant');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tour_package');
	}
}