<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpenseTable extends Migration {

	public function up()
	{
		Schema::create('expense', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->double('amount')->nullable();
			$table->datetime('date')->nullable();
			$table->string('type')->nullable();
			$table->string('group')->nullable();
			$table->string('from')->nullable();
			$table->text('description')->nullable();
			$table->text('description_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('expense');
	}
}