<?php

namespace App\Models;

class Leacture extends Eloquent {

	protected $table = 'leactures';
	public $timestamps = true;
	protected $fillable = array('name', 'description', 'deuration', 'vedio', 'course_id', 'content_id');

	public function course()
	{
		return $this->belongsTo('App\Models\Course');
	}

	public function resources()
	{
		return $this->hasMany('App\Models\Resourse');
	}

	public function content()
	{
		return $this->belongsTo('App\Models\Content');
	}

	public function student()
	{
		return $this->belongsToMany('App\Models\Student', 'student_leacture')->withPivot('note');
	}

	public function reports()
	{
		return $this->morphToMany('App\Models\Student', 'reportable')->withPivot('description');
	}

}