<?php

namespace App\Models;

class Instractors extends Eloquent {

	protected $table = 'instractors';
	public $timestamps = true;
	protected $fillable = array('student_id');

	public function student()
	{
		return $this->belongsTo('App\Models\Student');
	}

	public function courses()
	{
		return $this->hasMany('App\Models\Course');
	}

	public function reports()
	{
		return $this->morphToMany('App\Models\Student', 'reportable');
	}

}