<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployersTable extends Migration {

	public function up()
	{
		Schema::create('employers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255);
			$table->integer('type')->unsigned();
			$table->integer('size');
			$table->string('website');
			$table->string('registration_number');
			$table->integer('no_of_years');
		});
	}

	public function down()
	{
		Schema::drop('employers');
	}
}