<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('subject', 255);
			$table->tinyInteger('status');
			$table->integer('category_id')->unsigned();
			$table->text('description');
			$table->integer('event_reporter_id');
			$table->tinyInteger('severity');
			$table->integer('location_id')->unsigned();
			$table->integer('contact_id');
			$table->integer('ticket_id')->unsigned()->nullable();
			$table->integer('event_handler_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}