<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sub_tables', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu_item_categories', function(Blueprint $table) {
			$table->foreign('menu_category_id')->references('id')->on('menu_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu_item_categories', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu_item_ingredients', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu_item_ingredients', function(Blueprint $table) {
			$table->foreign('ingredient_id')->references('id')->on('ingredients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu_category_ingredients', function(Blueprint $table) {
			$table->foreign('ingredient_id')->references('id')->on('ingredients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('menu_category_ingredients', function(Blueprint $table) {
			$table->foreign('menu_category_id')->references('id')->on('menu_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('sub_table_id')->references('id')->on('sub_tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('table_id')->references('id')->on('tables')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('waiter_id')->references('id')->on('waiters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('menu_item_id')->references('id')->on('menu_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sub_tables', function(Blueprint $table) {
			$table->dropForeign('sub_tables_table_id_foreign');
		});
		Schema::table('menu_items', function(Blueprint $table) {
			$table->dropForeign('menu_items_area_id_foreign');
		});
		Schema::table('menu_item_categories', function(Blueprint $table) {
			$table->dropForeign('menu_item_categories_menu_category_id_foreign');
		});
		Schema::table('menu_item_categories', function(Blueprint $table) {
			$table->dropForeign('menu_item_categories_menu_item_id_foreign');
		});
		Schema::table('menu_item_ingredients', function(Blueprint $table) {
			$table->dropForeign('menu_item_ingredients_menu_item_id_foreign');
		});
		Schema::table('menu_item_ingredients', function(Blueprint $table) {
			$table->dropForeign('menu_item_ingredients_ingredient_id_foreign');
		});
		Schema::table('menu_category_ingredients', function(Blueprint $table) {
			$table->dropForeign('menu_category_ingredients_ingredient_id_foreign');
		});
		Schema::table('menu_category_ingredients', function(Blueprint $table) {
			$table->dropForeign('menu_category_ingredients_menu_category_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_sub_table_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_table_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_waiter_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_menu_item_id_foreign');
		});
	}
}