<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RequestStatus extends Eloquent {

	protected $table = 'request_status';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('status_name', 'status_color');
	protected $visible = array('status_name', 'status_color');

	public function requests()
	{
		return $this->hasMany('Request', 'status_id');
	}

}