<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->index()->default('0');
			$table->string('status_id', 60)->index();
			$table->text('request_content');
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}