<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->string('date_of_birth');
			$table->integer('blood_type_id');
			$table->string('phone');
			$table->integer('city_id');
			$table->tinyInteger('activated')->default('0');
			$table->string('last_date_donated');
			$table->integer('verification_code');
			$table->string('password');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}