<?php

namespace App;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'date_of_birth', 'blood_type_id', 'phone', 'city_id', 'last_date_donated', 'verification_code', 'password');

	public function governorates()
	{
		return $this->belongsToMany('Governorate');
	}

	public function city()
	{
		return $this->belongsTo('App\City');
	}

	public function blood_types()
	{
		return $this->belongsToMany('App\BloodType');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Post');
	}

	public function donation_requests()
	{
		return $this->hasMany('App\DonationRequests');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Notification');
	}

	public function blood_type()
	{
		return $this->belongsTo('App\BloodType');
	}

	public function contacts()
	{
		return $this->hasOne('App\Connect');
	}

}