<?php

namespace App\models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Admin extends Eloquent {

	protected $table = 'admins';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'photo', 'email', 'role');

	public function areas()
	{
		return $this->belongsTo('App\models\Area', 'area_id');
	}

}