<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletChargesTable extends Migration {

	public function up()
	{
		Schema::create('wallet_charges', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('bank_id')->unsigned();
			$table->string('amount')->nullable();
			$table->string('transfer_image')->nullable();
			$table->string('transfer_number')->nullable();
			$table->string('transfer_date')->nullable();
			$table->timestamps();
			$table->string('transfer_name')->nullable();
			$table->enum('status', array('new', 'approve', 'decline'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('wallet_charges');
	}
}