<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->string('count')->nullable();
			$table->bigInteger('category_id')->unsigned();
			$table->string('client_price')->nullable();
			$table->string('merchant_price')->nullable();
			$table->enum('online_card', array('true', 'false'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}