<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyInfoTable extends Migration {

	public function up()
	{
		Schema::create('company_info', function(Blueprint $table) {
			$table->bigInteger('company_info_id', true)->unique();
			$table->bigInteger('user_id')->unsigned();
			$table->string('name', 255);
			$table->text('service_area');
			$table->integer('membership')->unsigned();
			$table->bigInteger('created_by')->unsigned();
			$table->datetime('created');
			$table->datetime('modified');
		});
	}

	public function down()
	{
		Schema::drop('company_info');
	}
}