<?php

namespace myproject;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_has_user_type()
    {
        return $this->hasOne('User_type', 'user_type_id');
    }

    public function user_has_user_info()
    {
        return $this->hasOne('User_info', 'user_id');
    }

    public function user_has_user_profile()
    {
        return $this->hasOne('User_profile', 'user_id');
    }

}