<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryAddressTable extends Migration {

	public function up()
	{
		Schema::create('delivery_address', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('name', 256)->nullable();
			$table->string('country', 256)->nullable();
			$table->text('address')->nullable();
			$table->string('city', 256)->nullable();
			$table->smallInteger('pincode')->nullable();
			$table->integer('mobile')->nullable();
			$table->string('email', 256)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('delivery_address');
	}
}