<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 256)->nullable();
			$table->string('slug', 256)->nullable();
			$table->text('image')->nullable();
			$table->integer('order')->default('0');
			$table->integer('parent_id')->nullable();
			$table->string('parent_name', 256)->nullable();
			$table->text('size_chart')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}