<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100);
			$table->string('summary', 250);
			$table->text('description');
			$table->smallInteger('type');
			$table->decimal('latitude', 9,6);
			$table->decimal('longitude', 9,6);
			$table->text('address')->nullable();
			$table->boolean('hide_address')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}