<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingRatesTable extends Migration {

	public function up()
	{
		Schema::create('shipping_rates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('shipping_product_id')->unsigned();
			$table->integer('country_from')->unsigned();
			$table->integer('country_to')->unsigned();
			$table->decimal('price_default', 8,2)->nullable();
			$table->boolean('volume_weight');
			$table->boolean('customs');
			$table->decimal('fuel_tax', 8,2)->nullable();
			$table->enum('fuel_tax_type', array('percentage', 'fixed_price'));
			$table->text('carrier_rules')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_rates');
	}
}