<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCitiesTable extends Migration {

	public function up()
	{
		Schema::create('cities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('country_id')->unsigned();
			$table->text('name');
			$table->string('name-slug')->nullable();
			$table->text('postalcode')->nullable();
			$table->decimal('longitude', 10,6)->nullable();
			$table->decimal('latitude', 10,6)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('cities');
	}
}