<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingInsurancesTable extends Migration {

	public function up()
	{
		Schema::create('shipping_insurances', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('shipping_rate_id')->unsigned();
			$table->enum('type', array('value', 'weight'));
			$table->string('name', 50)->nullable();
			$table->string('name-slug', 50)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipping_insurances');
	}
}