<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingComany extends Model 
{

    protected $table = 'shipping_companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('name-slug');
    protected $fillable = array('name');

    public function products()
    {
        return $this->hasMany('ShippingProduct');
    }

}