<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_groups', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_has_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_has_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('role_group_id')->references('id')->on('role_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('organizations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('module_has_permissions', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('module_has_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('modules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('organization_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_organization_id_foreign');
		});
		Schema::table('role_groups', function(Blueprint $table) {
			$table->dropForeign('role_groups_organization_id_foreign');
		});
		Schema::table('user_has_roles', function(Blueprint $table) {
			$table->dropForeign('user_has_roles_role_id_foreign');
		});
		Schema::table('user_has_roles', function(Blueprint $table) {
			$table->dropForeign('user_has_roles_user_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_role_group_id_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_organization_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_role_id_foreign');
		});
		Schema::table('role_has_permissions', function(Blueprint $table) {
			$table->dropForeign('role_has_permissions_permission_id_foreign');
		});
		Schema::table('module_has_permissions', function(Blueprint $table) {
			$table->dropForeign('module_has_permissions_module_id_foreign');
		});
		Schema::table('module_has_permissions', function(Blueprint $table) {
			$table->dropForeign('module_has_permissions_permission_id_foreign');
		});
		Schema::table('modules', function(Blueprint $table) {
			$table->dropForeign('modules_parent_id_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_organization_id_foreign');
		});
	}
}