<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('name', 150);
			$table->string('mobile', 15);
			$table->string('email', 100);
			$table->string('password', 100)->nullable();
			$table->tinyInteger('status')->unsigned();
			$table->integer('organization_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}