<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriversTable extends Migration {

	public function up()
	{
		Schema::create('drivers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('first_name');
			$table->string('second_name');
			$table->string('third_name');
			$table->string('job_number');
			$table->string('phone_number');
			$table->string('national_id_number');
			$table->date('driving_license_expiration_date');
			$table->string('driving_license_number');
			$table->integer('municipal_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('drivers');
	}
}