<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DetailVenteProduit extends Model 
{

    protected $table = 'details_vente_produit';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function client()
    {
        return $this->hasOne('Client');
    }

    public function venteProduit()
    {
        return $this->hasOne('VenteProduit');
    }

    public function produit()
    {
        return $this->hasOne('Produit');
    }

}