<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function address()
    {
        return $this->hasMany('App\CompanyAddress');
    }

    public function links()
    {
        return $this->hasMany('App\Link');
    }

    public function pressCoverage()
    {
        return $this->hasMany('App\PressCoverage');
    }

    public function images()
    {
        return $this->belongsToMany('App\Image');
    }

    public function awards()
    {
        return $this->hasMany('App\Award');
    }

    public function teams()
    {
        return $this->hasMany('App\Team');
    }

    public function videos()
    {
        return $this->belongsToMany('App\Video');
    }

    public function downloads()
    {
        return $this->hasMany('App\Download');
    }

    public function testimonials()
    {
        return $this->hasMany('App\Testimonial');
    }

    public function pressReleases()
    {
        return $this->hasMany('App\PressRelease');
    }

    public function other_medias()
    {
        return $this->hasMany('App\OtherMedia');
    }

}