<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class Team extends Model 
{

    protected $table = 'teams';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('Models\User', 'user_id', 'id');
    }

    public function league()
    {
        return $this->belongsTo('Models\League', 'league_id', 'id');
    }

    public function matchups()
    {
        return $this->hasMany('Models\Matchup');
    }

    public function matchup_team()
    {
        return $this->belongsTo('Models\MatchupTeams', 'id', 'team_id');
    }

    public function trades_players()
    {
        return $this->belongsTo('Models\TradesPlayers', 'id', 'team_id');
    }

    public function rosters()
    {
        return $this->hasMany('Models\Roster', 'team_id', 'id');
    }

}