<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExamQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('exam_questions', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('course_id')->unsigned()->index();
			$table->bigInteger('exam_id')->unique();
			$table->bigInteger('section_id')->unsigned()->index();
			$table->string('question');
			$table->string('answer1');
			$table->string('answer2');
			$table->string('answer3');
			$table->string('answer4');
			$table->string('correct_answer');
			$table->integer('points');
		});
	}

	public function down()
	{
		Schema::drop('exam_questions');
	}
}