<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Teacher extends Model 
{

    protected $table = 'teachers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function courses()
    {
        return $this->hasMany('Course', 'teacher_id');
    }

    public function testimonials()
    {
        return $this->hasMany('TeacherTestimonial');
    }

}