<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'password');
    protected $hidden = array('password', 'remember_token');

    public function UsersHasInformations()
    {
        return $this->hasOne('App\Informations', 'id');
    }

    public function UsersHasCompetences()
    {
        return $this->hasMany('App\Competences', 'id');
    }

    public function UsersHasExperiences()
    {
        return $this->hasMany('App\Experiences', 'id');
    }

    public function UsersHasSocials()
    {
        return $this->hasMany('App\Social', 'id');
    }

}