<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('subject', 255);
			$table->text('message');
			$table->enum('type', array(''));
			$table->integer('contactable_id');
			$table->enum('rememberToken', array(''));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}