<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGuaranteesTable extends Migration {

	public function up()
	{
		Schema::create('guarantees', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('title', array('Mr', 'Mrs', 'Ms', 'Miss', 'Dr', 'Professor'))->index();
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name');
			$table->string('last_name');
			$table->string('email');
			$table->string('phone');
			$table->string('house_number');
			$table->string('address_line_1');
			$table->string('address_line_2');
			$table->string('city');
			$table->string('postcode');
			$table->string('registration_number');
			$table->smallInteger('registration_year');
			$table->string('colour');
			$table->string('interior');
			$table->date('start_date');
			$table->boolean('marketing_consent');
			$table->integer('model_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('guarantees');
	}
}