<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Guarantee extends Model 
{

    protected $table = 'guarantees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function model()
    {
        return $this->belongsTo('Model');
    }

    public function product()
    {
        return $this->belongsTo('Product');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}