<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAuthenticatableOtpsTable extends Migration {

	public function up()
	{
		Schema::create('authenticatable_otps', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('code');
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->boolean('active')->default(1);
			$table->nullableMorphs('authenticatable');
		});
	}

	public function down()
	{
		Schema::drop('authenticatable_otps');
	}
}