<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAlertsTable extends Migration {

	public function up()
	{
		Schema::create('alerts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->text('body');
			$table->boolean('display_per_session');
			$table->string('audience');
			$table->enum('delivery_timing', array('Immediate', 'Schedule'));
			$table->date('scheduled_time');
			$table->enum('announcement_type', array('Info', 'System', 'Marketing', 'Warning'));
			$table->enum('delivery_method', array('In-App', 'Email', 'Push'));
			$table->boolean('is_active')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('alerts');
	}
}